<?php

/**
 * @package mleasing
 */
function mleasing_wptuts_activate_au()
{
    require_once(__dir__ . '/wp_autoupdate.php');      // File which contains the Class below
    $wptuts_plugin_current_version = '2.3.0';
    $wptuts_plugin_remote_path = 'https://mportal.de/CDN/wordpress-plugin-update/update.php';
    $wptuts_plugin_slug = plugin_basename(__FILE__);
    new wp_auto_update($wptuts_plugin_current_version, $wptuts_plugin_remote_path, $wptuts_plugin_slug);
}

/*
Plugin Name: mleasing.de
Plugin URI: https://mportal.de/CDN/documentation/
Description: Um dieses Plugin nutzen zu können benötigen Sie eine Händlerkennung. Das Plugin wird mit einem der folgenden Shortcodes eingebunden: [alle_neuwagen] [bmw_neuwagen] [mini_neuwagen] Sie benötigen Hilfe? <a href="mailto:support@mleasing.de">support@mleasing.de</a>
Version: 2.3.0
Author: locarl GmbH
Author URI: https://locarl.de
License: GPLv2 or later
Text Domain: mleasing
MIN WP Version: 5.8.1
*/
$SCRIPT_NAMES = explode('/', $_SERVER["SCRIPT_NAME"]);
$pname = '';
foreach ($SCRIPT_NAMES as $pathnames) {
    if ($pathnames == 'wp-admin') {
        break;
    } else {
        $pname .= $pathnames . '/';
    }
}
/*
defined('ABSPATH') or die('No script kiddies please!');
$page_url = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
$actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]";
define('page_url', $actual_link . $pname . 'wp-content/plugins/mleasing/dist/');
define('plugin_url', $actual_link . $pname . 'wp-content/plugins/mleasing/');
*/
/*
echo '<pre>';
echo page_url;
var_dump($_SERVER);
echo '</pre>';
exit;
*/
function mleasing_register_settings()
{

    register_setting('mleasing_options_group', 'mleasing_apiKey_name');
}

add_action('admin_init', 'mleasing_register_settings');
function mleasing_setting_page()
{

    add_options_page('mleasing.de - Einstellungen', 'mleasing.de', 'manage_options', 'mleasing-setting-url', 'mleasing_page_html_form');
}

add_action('admin_menu', 'mleasing_setting_page');

function mleasing_page_html_form()
{ ?>
    <div class="wrap">
        <h2><?php printf(__('mleasing.de - Einstellungen', 'mleasing')); ?></h2>
        <p>Setzen Sie bitte Ihre Händlerkennung, welche Sie von Ihrem Ansprechpartner erhalten haben.</p>
        <form method="post" action="options.php">
            <?php settings_fields('mleasing_options_group'); ?>

            <table class="form-table">
                <tr>
                    <th><label for="mleasing_apiKey_id"><?php printf(__('Händlerkennung:', 'mleasing')); ?></label></th>
                    <td>
                        <input type='text' class="regular-text" id="mleasing_apiKey_id" name="mleasing_apiKey_name" value="<?php echo get_option('mleasing_apiKey_name'); ?>">
                    </td>
                </tr>
            </table>
            <?php submit_button(); ?>
    </div>
<?php }

function mleasing_init()
{
    $apikey = get_option('mleasing_apiKey_name');
    $content = '
    <div id="mleasingWrapper">
        <link href="https://mportal.de/CDN/assets/css/mleasing.app.css" rel="stylesheet">
        <script>
                var haendlerkennung = "' . $apikey . '";
        </script>
        <div id="mleasing"></div>
        <script src="https://mportal.de/CDN/assets/js/mleasing.app.js"></script>
    </div>';
    return $content;
}

function mleasing_init_bmw()
{
    $apikey = get_option('mleasing_apiKey_name');
    $content = '
    <div id="mleasingWrapper">
        <link href="https://mportal.de/CDN/assets/css/mleasing.app.css" rel="stylesheet">
        <script>
                var haendlerkennung = "' . $apikey . '";
                var marke = "bmw";
        </script>
        <div id="mleasing"></div>
        <script src="https://mportal.de/CDN/assets/js/mleasing.app.js"></script>
    </div>';
    return $content;
}

function mleasing_init_mini()
{
    $apikey = get_option('mleasing_apiKey_name');
    $content = '
    <div id="mleasingWrapper">
        <link href="https://mportal.de/CDN/assets/css/mleasing.app.css" rel="stylesheet">
        <script>
                var haendlerkennung = "' . $apikey . '";
                var marke = "mini";
        </script>
        <div id="mleasing"></div>
        <script src="https://mportal.de/CDN/assets/js/mleasing.app.js"></script>
    </div>';
    return $content;
}

function mleasing_init_finanzierung()
{
    $apikey = get_option('mleasing_apiKey_name');
    $content = '
    <div id="mleasingWrapper">
        <link href="https://mportal.de/CDN/assets/css/mleasing.app.css" rel="stylesheet">
        <script>
                var haendlerkennung = "' . $apikey . '";
                var ansicht = "finanzierung";
        </script>
        <div id="mleasing"></div>
        <script src="https://mportal.de/CDN/assets/js/mleasing.app.js"></script>
    </div>';
    return $content;
}

function mleasing_init_bmw_finanzierung()
{
    $apikey = get_option('mleasing_apiKey_name');
    $content = '
    <div id="mleasingWrapper">
        <link href="https://mportal.de/CDN/assets/css/mleasing.app.css" rel="stylesheet">
        <script>
                var haendlerkennung = "' . $apikey . '";
                var marke = "bmw";
                var ansicht = "finanzierung";
        </script>
        <div id="mleasing"></div>
        <script src="https://mportal.de/CDN/assets/js/mleasing.app.js"></script>
    </div>';
    return $content;
}

function mleasing_init_mini_finanzierung()
{
    $apikey = get_option('mleasing_apiKey_name');
    $content = '
    <div id="mleasingWrapper">
        <link href="https://mportal.de/CDN/assets/css/mleasing.app.css" rel="stylesheet">
        <script>
                var haendlerkennung = "' . $apikey . '";
                var marke = "mini";
                var ansicht = "finanzierung";
        </script>
        <div id="mleasing"></div>
        <script src="https://mportal.de/CDN/assets/js/mleasing.app.js"></script>
    </div>';
    return $content;
}

//add_action( 'init', 'mleasing_wptuts_activate_au' );
add_shortcode('alle_jga', 'mleasing_init');
add_shortcode('bmw_jga', 'mleasing_init_bmw');
add_shortcode('mini_jga', 'mleasing_init_mini');

add_shortcode('alle_jga_finanzierung', 'mleasing_init_finanzierung');
add_shortcode('bmw_jga_finanzierung', 'mleasing_init_bmw_finanzierung');
add_shortcode('mini_jga_finanzierung', 'mleasing_init_mini_finanzierung');
?>